<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage Superio
 * @since Superio 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Corporation",
  "name": "Vieclamdigital.com - Website đăng tin tuyển dụng việc làm Marketing lương cao 2024",
  "alternateName": "Vieclamdigital",
  "url": "https://vieclamdigital.com",
  "logo": "https://vieclamdigital.com/wp-content/uploads/elementor/thumbs/vieclamdigital-logo-qj1zrwld02tpmjp8rrvits6m3gzuooswm1qrk7oe46.png",
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "0847 280 662",
    "contactType": "technical support",
    "contactOption": "TollFree",
    "areaServed": "VN",
    "availableLanguage": "Vietnamese"
  },
  "sameAs": [
    "https://www.youtube.com/@Vieclamdigital",
    "https://www.pinterest.com/vieclam365/",
    "https://www.linkedin.com/in/vieclamdigital/",
    "https://twitter.com/Vieclamdigital",
    "https://www.reddit.com/user/Vieclamdigital/",
    "https://alovieclam-365.tumblr.com/",
    "https://sites.google.com/view/vieclamdigital",
    "https://www.blogger.com/profile/06301028329443070658"
  ]
}
</script>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "ProfessionalService",
  "name": "Vieclamdigital.com - Website đăng tin tuyển dụng việc làm Marketing lương cao 2024",
  "image": "https://vieclamdigital.com/wp-content/uploads/elementor/thumbs/vieclamdigital-logo-qj1zrwld02tpmjp8rrvits6m3gzuooswm1qrk7oe46.png",
  "@id": "https://vieclamdigital.com",
  "url": "https://vieclamdigital.com",
  "telephone": "0847 280 662",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "32 Hẻm B13F, Tổ 21, Bình Chánh, Thành phố Hồ Chí Minh, Việt Nam",
    "addressLocality": "Thành phố Hồ Chí Minh",
    "postalCode": "70000",
    "addressCountry": "VN"
  },
  "geo": {
    "@type": "GeoCoordinates",
    "latitude": 10.7887853,
    "longitude": 106.5860409
  },
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday"
    ],
    "opens": "00:00",
    "closes": "23:59"
  },
  "sameAs": [
    "https://www.youtube.com/@Vieclamdigital",
    "https://www.pinterest.com/vieclam365/",
    "https://www.linkedin.com/in/vieclamdigital/",
    "https://twitter.com/Vieclamdigital",
    "https://www.reddit.com/user/Vieclamdigital/",
    "https://alovieclam-365.tumblr.com/",
    "https://sites.google.com/view/vieclamdigital",
    "https://www.blogger.com/profile/06301028329443070658"
  ] 
}
</script>
	<script type="application/ld+json">
{
  "@context": "https://schema.org/",
  "@type": "Person",
  "name": "Bùi Duy Anh",
  "url": "https://vieclamdigital.com/author/admin/",
  "image": "https://htmediagroup.vn/wp-content/uploads/2022/09/Anh-cty-10-min.jpg",
  "sameAs": [
    "https://www.youtube.com/@ceobuiduyanh",
    "https://www.pinterest.com/ceobuiduyanh/",
    "https://www.pinterest.com/ceobuiduyanh/",
    "https://twitter.com/ceobuiduyanh",
    "https://www.reddit.com/user/buiduyanh/",
    "https://ceobuiduyanh.tumblr.com/",
    "https://sites.google.com/view/buiduyanh",
    "https://www.blogger.com/profile/02965507076911602345"
  ],
  "jobTitle": "CEO",
  "worksFor": {
    "@type": "Organization",
    "name": "Vieclamdigital"
  }  
}
</script>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="//gmpg.org/xfn/11">
	
	<?php wp_head(); ?>
	<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-YZ4ZX83KTN"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-YZ4ZX83KTN');
</script>
	<meta name='dmca-site-verification' content='YUxLRlRIRVROMjh1TnY3dFIxNlUxOE1rUEg2VU40RjlBU2dCR3pNSGxsdz01' />
</head>
<body <?php body_class(); ?>>
<?php if ( superio_get_config('preload', true) ) {
	$preload_icon = superio_get_config('media-preload-icon');
	$styles = array();
	if ( !empty($preload_icon['id']) ) {
		$img = wp_get_attachment_image_src($preload_icon['id'], 'full');
		if ( !empty($img[0]) ) {
			$styles[] = 'background-image: url(\''.$img[0].'\');';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'width: '.$img[1].'px;';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'height: '.$img[2].'px;';
		}
    }
    $style_attr = '';
    if ( !empty($styles) ) {
    	$style_attr = 'style="'.implode(' ', $styles).'"';
    }
?>
	<div class="apus-page-loading">
        <div class="apus-loader-inner" <?php echo trim($style_attr); ?>></div>
    </div>
<?php } ?>
<div id="wrapper-container" class="wrapper-container">
	<?php
    if ( function_exists( 'wp_body_open' ) ) {
        wp_body_open();
    }
    if ( superio_get_config('separate_header_mobile', true) ) {
	    get_template_part( 'headers/mobile/offcanvas-menu' );
		get_template_part( 'headers/mobile/header-mobile' );
	}
	?>

	<?php
		$header = apply_filters( 'superio_get_header_layout', superio_get_config('header_type') );
		if ( !empty($header) ) {
			superio_display_header_builder($header);
		} else {
			get_template_part( 'headers/default' );
		}
	?>
	<div id="apus-main-content">